package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI.AssignmentInfo;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.ShipwideAIFlags.AIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PunisherJetsAI implements ShipSystemAIScript {

    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;

    private final IntervalUtil tracker = new IntervalUtil(0.75f, 1.5f);

    @Override
    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (engine.isPaused()) {
            return;
        }

        tracker.advance(amount);

        if (tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame(ship)) {
                return;
            }

            float decisionLevel = 0f;

            AssignmentInfo assignment = engine.getFleetManager(ship.getOwner()).getTaskManager(ship.isAlly()).getAssignmentFor(ship);
            Vector2f targetSpot;
            if (assignment != null && assignment.getTarget() != null) {
                targetSpot = assignment.getTarget().getLocation();
            } else {
                targetSpot = null;
            }
            boolean pointedAtTargetSpot = false;
            if (targetSpot != null) {
                float angleToTargetSpot = VectorUtils.getAngle(ship.getLocation(), targetSpot);
                if (MathUtils.getShortestRotation(angleToTargetSpot, ship.getFacing()) <= 45f) {
                    pointedAtTargetSpot = true;
                }
            }
            boolean pointedAtTarget = false;
            boolean pointedAwayFromTarget = false;
            if (target != null) {
                float angleToTarget = VectorUtils.getAngle(ship.getLocation(), target.getLocation());
                if (MathUtils.getShortestRotation(angleToTarget, ship.getFacing()) <= 45f) {
                    pointedAtTarget = true;
                } else if (MathUtils.getShortestRotation(angleToTarget, ship.getFacing()) >= 90f) {
                    pointedAwayFromTarget = true;
                }
            }

            if (assignment != null && assignment.getType() == CombatAssignmentType.RETREAT) {
                float retreatDirection = (ship.getOwner() == 0) ? 270f : 90f;
                if (Math.abs(MathUtils.getShortestRotation(ship.getFacing(), retreatDirection)) <= 60f) {
                    decisionLevel += 15f;
                } else if (Math.abs(MathUtils.getShortestRotation(ship.getFacing(), retreatDirection)) > 90f) {
                    decisionLevel -= 15f;
                }
            }

            if (flags.hasFlag(AIFlags.RUN_QUICKLY)) {
                if (pointedAwayFromTarget) {
                    decisionLevel += 10f;
                } else {
                    decisionLevel -= 10f;
                }
            } else if (flags.hasFlag(AIFlags.PURSUING) || flags.hasFlag(AIFlags.HARASS_MOVE_IN)) {
                if (pointedAtTarget) {
                    decisionLevel += 10f;
                }
            } else if (flags.hasFlag(AIFlags.MANEUVER_TARGET)) {
                if (pointedAtTarget) {
                    decisionLevel += 8f;
                }
            } else if (targetSpot != null) {
                if (pointedAtTargetSpot && !pointedAtTarget) {
                    decisionLevel += 12f;
                }
            }

            if (flags.hasFlag(AIFlags.DO_NOT_PURSUE)) {
                decisionLevel -= 5f;
            }
            if (flags.hasFlag(AIFlags.NEEDS_HELP)) {
                if (pointedAwayFromTarget) {
                    decisionLevel += 5f;
                } else {
                    decisionLevel -= 10f;
                }
            }
            if (flags.hasFlag(AIFlags.BACK_OFF) || flags.hasFlag(AIFlags.BACK_OFF_MIN_RANGE) || flags.hasFlag(AIFlags.BACKING_OFF)) {
                if (pointedAwayFromTarget) {
                    decisionLevel += 5f;
                } else {
                    decisionLevel *= 0.5f;
                }
            }

            if (decisionLevel >= 7f) {
                ship.useSystem();
            }
        }
    }

    @Override
    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}
